from src.agents.judge import Judge
import os
os.environ['OPENAI_API_BASE'] = 'xxxxxx'
import numpy as np
from tqdm import trange,tqdm
import threading
from src.model import APIModel
from src.utils import tokenCounter
from src.database import database


def multi_criteria_juding(models, criteria, survey, topic,):
    db = database(db_path="./paper_db_nomic/")
    judge_l = [Judge(model=model, api_key='xxxxx', database=db) for model in models]

    def criteria_judging(judge, scores_l, idx):
        s = judge.batch_criteria_based_judging(survey, topic, criteria)
        # print(s)
        scores_l[idx] = s

    thread_l = []
    scores_l = [None] * len(judge_l)
    for i in range(len(judge_l)):
        thread = threading.Thread(target=criteria_judging, args=(judge_l[i], scores_l, i))
        thread_l.append(thread)
        thread.start()
    for thread in thread_l:
        thread.join()

    price = 0
    for judge in judge_l:
        price += judge.compute_price()
    print(price)
    return np.array(scores_l).mean(axis=0)
    return scores_l